
using System;
using System.Collections.Generic;
using System.Text;

namespace PI.ZB.N1200.ELearning.BL.DBD.View
{
    internal class Class : PI.FM.N000.Base.BL.DBD.BaseTable<BO.View.Class>
    {
        #region Static factory
        private static Class _factory = null;

        public static Class DBD
        {
            get
            {
                if (_factory == null)
                {
                    _factory = new Class();
                }
                return _factory;
            }
        }
        #endregion

        #region Override - Initialization
        protected override void InitializeTableName()
        {
            _tableName = "PIZB1200_ClassView";
        }

        protected override void InitializeProperties()
        {
            Add(new PI.FM.N000.Base.BL.DBD.LongProperty("SchoolID", "SchoolID"));
            Add(new PI.FM.N000.Base.BL.DBD.LongProperty("SchoolYearID", "SchoolYearID"));            
            Add(new PI.FM.N000.Base.BL.DBD.LongProperty("InstructorID", "InstructorID"));
            Add(new PI.FM.N000.Base.BL.DBD.StringProperty("Name", "Name"));

            Add(new PI.FM.N000.Base.BL.DBD.StringProperty("SchoolName", "SchoolName"));
            Add(new PI.FM.N000.Base.BL.DBD.StringProperty("SchoolYear", "SchoolYear"));
            Add(new PI.FM.N000.Base.BL.DBD.StringProperty("InstructorForename", "InstructorForename"));
            Add(new PI.FM.N000.Base.BL.DBD.StringProperty("InstructorSurename", "InstructorSurename"));
        }
        #endregion

        #region Commands definition
        public enum Commands
        {
            RestoreBySearch = 20
        }
        #endregion

        #region Get Commands
        protected override Gemini.Core.BL.Interface.DBD.ICommand DoGetCommand(int CommandID)
        {
            switch (CommandID)
            {
                case (int)Commands.RestoreBySearch: return new Command_RestoreBySearch();
            }

            return base.DoGetCommand(CommandID);
        }
        #endregion

        #region Additional Commands Classes
        class Command_RestoreBySearch : PI.FM.N000.Base.BL.DBD.BaseCommand<BO.Class>
        {
            public Command_RestoreBySearch() : base(PI.ZB.N1200.ELearning.BL.DBD.Class.DBD, Gemini.Core.BL.DBD.CommandType.StoredProcedure) { }

            protected override void InitializeParametrs()
            {
                Add(new Gemini.Core.BL.DBD.Param("SchoolID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("SchoolYearID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("InstructorID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("Name", Gemini.Core.BL.DAL.SqlTypes.NVarChar));
            }

            protected override void InitializeCommandText()
            {
                _commandText = "PIZB1200_ClassView_RestoreBySearch";
            }
        }
        #endregion
    }
}